<?php
/**
 * Script for tracking direct downloads with Piwik-powered web analytics.
 * 2013-02-27, by Amenel VOGLOZIN @ khalemy.com
 * All (my) rights abandoned: my work is public domain and this entire script package comes with absolutely NO WARRANTY.
 *
 * You are invited to copy, amend, modify, fix, torture, praise and whatnot. Oh, and USE of course :-)
 * Please, do not remove the copyright notice further down in the file!
 *
 * INFORMATION:
 * This script was built atop Armand Niculescu's file download script (which can be found further in this file).
 * If you want to locate my changes to Armand's script: search "BEGIN $$waav" in this file. My changes are mainly constrained to two sections of this file. The other changes relate to error messages.
 *
 * WEBPAGE ADRESS:
 * https://www.khalemy.com/software/ddt-for-piwik/
 *
 * INSTRUCTIONS: either read the documentation on the website or follow the steps below.
 * - drop (onto your server) the configuration file that is mentioned in the ADAPT section (search this file for "ADAPT"),
 * - change the contents of the configuration file where necessary,
 * - change (in this file) the path to the .inc file (see the ADAPT section),
 * - don't forget to add (to this file) all “exotic” MIME types that may be pertinent with respect to the files that you offer for download.
 * - in case counting the number of downloads is of any use to you, create the database, table and user (example given in download_tracker.sql).
 * - That's all, meaning DON'T DO ANYTHING ELSE -- unless you **really** know what your are doing :-)
 *
 *
 *
 * VERSION CHANGES:
 * - 2013-02-27: Initial version.
 * - 2013-05-24: Added getRealIpAddr() function.
 * - 2013-07-01: Updated error messages.
 * - 2013-07-31: Moved the site-specific configuration to a "piwik_direct_downloads_config.inc" file to be included. I did this so that I could use a single download.php file for my websites.
 * - 2013-08-02: Added "test" parameter in order to avoid logging test downloads
 * - 2014-04-28: When using a folder path in the 'file' parameter, the filename the user is presented with no longer contains the folder path. Before: folder/filename.txt => folder_filename.txt. After: folder/filename.txt => filename.txt
 * - 2015-07-06: Added support for saving the number of downloads to a database; moved the path to the PiwikTracker.php file to the config file; some code cleaning.
 *
 */
// BEGIN $$waav
//
//
// BEGIN ADAPT - You need to adapt each line of this section to the configuration of your server. NOTE: Relative paths
// are filesystem paths relative to this download.php file
//
// This is a filesystem (absolute or relative) path.
require_once 'piwik_direct_downloads_config.inc';
//
// This is a filesystem (absolute or relative) path.
require_once $ddtIncludePath;
//
//
// END ADAPT ------------
function getRealIpAddr() // this function is copied as-is from http://roshanbh.com.np/2007/12/getting-real-ip-address-in-php.html
{
	if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
		$ip = $_SERVER['HTTP_CLIENT_IP'];
	} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
		$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
	} else {
		$ip = $_SERVER['REMOTE_ADDR'];
	}
	return $ip;
}

// BEGIN $$waav
function incrementCount($request_path, $dbHost, $dbName, $dbLogin, $dbPassword, $dbTable)
{
	$downloadCount = 0;

	$mysqli = new mysqli($dbHost, $dbLogin, $dbPassword, $dbName);
	if ($mysqli->connect_errno) {
		die("Connection to database <" . $dbName . "> failed.");
	}

	// check whether the file/path already has a record in the database
	$record_exists = false;
	$check_stmt = $mysqli->prepare("SELECT NbDownloads FROM " . $dbTable . " WHERE Path=?");
	$check_stmt->bind_param("s", $request_path);
	$check_stmt->execute();
	$check_stmt->bind_result($downloadCount);
	$fetch_val = $check_stmt->fetch();
	$check_stmt->close();
	$record_exists = ($fetch_val !== null);

	// if no existing record, insert one, with the download count at 0
	if (!$record_exists) {
		$insert_stmt = $mysqli->prepare("INSERT INTO " . $dbTable . " VALUES (?, 0, NOW(), NOW())");
		$insert_stmt->bind_param("s", $request_path);
		$insert_stmt->execute();
		$insert_stmt->close();
	}

	// increase the download count
	$downloadCount++;

	// store the new value
	$update_stmt = $mysqli->prepare("UPDATE " . $dbTable . " SET NbDownloads=?, AccessDate=NOW() WHERE Path=?");
	$update_stmt->bind_param("is", $downloadCount, $request_path);
	$update_stmt->execute();
	$update_stmt->close();

	$mysqli->close();
}

$doNotRecordVisit = isset($_REQUEST['test']) && !empty($_REQUEST['test']);
//
// END $$waav
/**
 * Copyright 2012 Armand Niculescu - MediaDivision.com
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
 * 1.
 * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * THIS SOFTWARE IS PROVIDED BY THE FREEBSD PROJECT "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE FREEBSD PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
// get the file request, throw error if nothing supplied

// hide notices
@ini_set('error_reporting', E_ALL & ~E_NOTICE);

// - turn off compression on the server
// @apache_setenv('no-gzip', 1); // $$waav: this causes all of my websites to fail sending the file. Don't know why.
@ini_set('zlib.output_compression', 'Off');

if (!isset($_REQUEST['file']) || empty($_REQUEST['file'])) {
	header("HTTP/1.0 400 Bad Request");
	echo "<h1>400 Bad Request</h1> <p>No 'file' parameter was given.</p>";
	exit();
}

// sanitize the file request, keep just the name and extension
// also, replaces the file location with a preset one ('./myfiles/' in this example)
// BEGIN $$waav
$request_path = $_REQUEST['file'];
//
$path_parts = pathinfo($request_path);

// Name under which the user will be offered to save the file.
$file_name = $path_parts['basename'];

$file_ext = $path_parts['extension'];

// Complete filesystem path to the file to send.
$file_path = $downloadsFolder . $request_path;
if (!$doNotRecordVisit) {
	$t = new PiwikTracker($idSite, $siteName);

	$t->setUserAgent($_SERVER['HTTP_USER_AGENT']);
	$t->setLocalTime(date('H:i:s'));
	$t->setBrowserHasCookies(isset($_COOKIE) && !empty($_COOKIE));
	$t->setTokenAuth($token_auth);
	$t->setIp(getRealIpAddr());
	$t->doTrackPageView($useGenericName ? $genericDirectDownloadPageName : $request_path);
}
//
// END $$waav

// allow a file to be streamed instead of sent as an attachment
$is_attachment = isset($_REQUEST['stream']) ? false : true;

// make sure the file exists
if (is_file($file_path)) {
	$file_size = filesize($file_path);
	$file = @fopen($file_path, "rb");
	if ($file) {
		// set the headers, prevent caching
		header("Pragma: public");
		header("Expires: -1");
		header("Cache-Control: public, must-revalidate, post-check=0, pre-check=0");
		header("Content-Disposition: attachment; filename=\"$file_name\"");

		// set appropriate headers for attachment or streamed file
		if ($is_attachment) {
			header("Content-Disposition: attachment; filename=\"$file_name\"");
		} else {
			header('Content-Disposition: inline;');
			header('Content-Transfer-Encoding: binary');
		}

		// set the mime type based on extension, add yours if needed.
		$ctype_default = "application/octet-stream";
		$content_types = array (
			"pdf" => "application/pdf",
			"exe" => "application/octet-stream",
			"zip" => "application/zip",
			"mp3" => "audio/mpeg",
			"mpg" => "video/mpeg",
			"avi" => "video/x-msvideo"
		);
		$ctype = isset($content_types[$file_ext]) ? $content_types[$file_ext] : $ctype_default;
		header("Content-Type: " . $ctype);

		// check if http_range is sent by browser (or download manager)
		if (isset($_SERVER['HTTP_RANGE'])) {
			list ($size_unit, $range_orig) = explode('=', $_SERVER['HTTP_RANGE'], 2);
			if ($size_unit == 'bytes') {
				// multiple ranges could be specified at the same time, but for simplicity only serve the first range
				// http://tools.ietf.org/id/draft-ietf-http-range-retrieval-00.txt
				list ($range, $extra_ranges) = explode(',', $range_orig, 2);
			} else {
				$range = '';
				header('HTTP/1.1 416 Requested Range Not Satisfiable');
				exit();
			}
		} else {
			$range = '';
		}

		// figure out download piece from range (if set)
		list ($seek_start, $seek_end) = explode('-', $range, 2);

		// set start and end based on range (if set), else set defaults
		// also check for invalid ranges.
		$seek_end = (empty($seek_end)) ? ($file_size - 1) : min(abs(intval($seek_end)), ($file_size - 1));
		$seek_start = (empty($seek_start) || $seek_end < abs(intval($seek_start))) ? 0 : max(abs(intval($seek_start)), 0);

		// Only send partial content header if downloading a piece of the file (IE workaround)
		if ($seek_start > 0 || $seek_end < ($file_size - 1)) {
			header('HTTP/1.1 206 Partial Content');
			header('Content-Range: bytes ' . $seek_start . '-' . $seek_end . '/' . $file_size);
			header('Content-Length: ' . ($seek_end - $seek_start + 1));
		} else
			header("Content-Length: $file_size");

		header('Accept-Ranges: bytes');

		set_time_limit(0);
		fseek($file, $seek_start);

		while (!feof($file)) {
			print(@fread($file, 1024));
			ob_flush();
			flush();
			if (connection_status() != 0) {
				@fclose($file);
				exit();
			}
		}

		// file save was a success
		@fclose($file);
		// BEGIN $$waav
		if ($countDownloads/* && !$doNotRecordVisit */) {
			incrementCount($request_path, $dbHost, $dbName, $dbLogin, $dbPassword, $dbTable);
		}
		// END $$waav
		exit();
	} else {
		// file couldn't be opened
		header("HTTP/1.0 500 Internal Server Error");
		echo "<h1>500 Internal Server Error</h1> <p>The file could not be read.</p>";
		exit();
	}
} else {
	// file does not exist
	header("HTTP/1.0 404 Not Found");
	echo "<h1>404 Not found</h1> <p>Please check the file name (character case, spelling, HTML encoding of special characters…).</p><br/>";
	echo "Received file name: <b>" . $request_path . "<b>";
	exit();
}
?>